package com.example.sefinsa_app.ui.avales.fotos;

import androidx.core.app.ActivityCompat;
import androidx.core.content.ContextCompat;
import androidx.lifecycle.ViewModelProvider;

import android.Manifest;
import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.ProgressDialog;
import android.content.ContentValues;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.location.Location;
import android.location.LocationManager;
import android.net.Uri;
import android.os.Bundle;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;
import androidx.navigation.Navigation;

import android.os.Looper;
import android.provider.MediaStore;
import android.provider.Settings;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.TextView;
import android.widget.Toast;

import com.example.sefinsa_app.R;
import com.example.sefinsa_app.api.API;
import com.example.sefinsa_app.models.Aval;
import com.example.sefinsa_app.utilities.CurrentFragment;
import com.example.sefinsa_app.utilities.RealPathUtil;
import com.example.sefinsa_app.utilities.ResponseMe;
import com.example.sefinsa_app.utilities.RetrofitInterface;
import com.example.sefinsa_app.utilities.Utils;
import com.google.android.material.dialog.MaterialAlertDialogBuilder;

import org.json.JSONObject;

import java.io.File;
import java.util.ArrayList;
import java.util.List;

import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.RequestBody;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Retrofit;
import retrofit2.converter.gson.GsonConverterFactory;

public class AvalesFotosGarantiasFragment extends Fragment {

    private AvalesFotosViewModel mViewModel;

    private final int CODIGO_PERMISOS_CAMARA = 1;

    private Button btnImagenesGarantiasAval, btnImagenesComprobantesAval,
            btnGuardarFotos;

    private boolean camaraGarantiasAvalAbierta = false, camaraComprobantesAvalAbierta = false;

    List<MultipartBody.Part> archivosGeneral;

    private ArrayList<String> pathsGarantiasAval;
    private ArrayList<String> pathsComprobantesAval;

    private Aval aval;

    private int banderaGarantiasAvales, banderaComprobantesAvales;

    String path;

    private Uri image_uri;

    private TextView tvAval;

    public static AvalesFotosGarantiasFragment newInstance() {
        return new AvalesFotosGarantiasFragment();
    }

    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container,
                             @Nullable Bundle savedInstanceState) {
        return inflater.inflate(R.layout.fragment_clientes_fotos_garantias, container, false);
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);

        Bundle args = getArguments();
        String personJsonString = args.getString("aval");
        aval = Utils.getGsonParser().fromJson(personJsonString, Aval.class);

        initElements(view);


    }

    private void initElements(View view) {

        CurrentFragment.fragment = "ClientesFotosGarantiasFragment";

        tvAval = view.findViewById(R.id.tvAval);

        tvAval.setText("Aval " + aval.getNombre_completo());

        pathsComprobantesAval = new ArrayList<>();
        pathsGarantiasAval = new ArrayList<>();

        btnImagenesGarantiasAval = view.findViewById(R.id.btnCamaraGarantiasAval);
        btnImagenesComprobantesAval = view.findViewById(R.id.btnCamaraComprobantesAval);
        btnGuardarFotos = view.findViewById(R.id.btnGuardarFotos);

        archivosGeneral = new ArrayList<>();

        btnImagenesComprobantesAval.setOnClickListener(view13 -> {

            int permisoCamara = ContextCompat.checkSelfPermission(getActivity(), Manifest.permission.CAMERA);
            int permisoAlmacen = ContextCompat.checkSelfPermission(getActivity(), Manifest.permission.WRITE_EXTERNAL_STORAGE);

            if (permisoCamara == PackageManager.PERMISSION_GRANTED && permisoAlmacen == PackageManager.PERMISSION_GRANTED) {

                camaraGarantiasAvalAbierta = false;
                camaraComprobantesAvalAbierta = true;

                openCameraIntent();

            } else {
                ActivityCompat.requestPermissions(getActivity(),
                        new String[]{Manifest.permission.CAMERA, Manifest.permission.WRITE_EXTERNAL_STORAGE},
                        CODIGO_PERMISOS_CAMARA);

            }
        });

        btnImagenesGarantiasAval.setOnClickListener(view14 -> {

            int permisoCamara = ContextCompat.checkSelfPermission(getActivity(), Manifest.permission.CAMERA);
            int permisoAlmacen = ContextCompat.checkSelfPermission(getActivity(), Manifest.permission.WRITE_EXTERNAL_STORAGE);

            if (permisoCamara == PackageManager.PERMISSION_GRANTED && permisoAlmacen == PackageManager.PERMISSION_GRANTED) {

                camaraGarantiasAvalAbierta = true;
                camaraComprobantesAvalAbierta = false;

                openCameraIntent();

            } else {
                ActivityCompat.requestPermissions(getActivity(),
                        new String[]{Manifest.permission.CAMERA, Manifest.permission.WRITE_EXTERNAL_STORAGE},
                        CODIGO_PERMISOS_CAMARA);

            }
        });

        btnGuardarFotos.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {

                if (pathsComprobantesAval.size() == 0 && pathsGarantiasAval.size() == 0 ) {

                    new MaterialAlertDialogBuilder(getActivity())
                            .setTitle("Aviso")
                            .setMessage("No se han tomado fotos para subir")
                            .setPositiveButton("Ok", new DialogInterface.OnClickListener() {
                                @Override
                                public void onClick(DialogInterface dialogInterface, int i) {
                                }
                            })
                            .show();
                } else {
                    subirFotos();
                }

            }
        });
    }

    private void openCameraIntent() {
        ContentValues values = new ContentValues();

        values.put(MediaStore.Images.Media.TITLE, "Imagen ejemplo");
        values.put(MediaStore.Images.Media.DESCRIPTION, "Camara ejemplo");

        image_uri = getContext().getContentResolver().insert(MediaStore.Images.Media.EXTERNAL_CONTENT_URI, values);

        Intent i = new Intent(MediaStore.ACTION_IMAGE_CAPTURE);
        i.putExtra(MediaStore.EXTRA_OUTPUT, image_uri);
        startActivityForResult(i, CODIGO_PERMISOS_CAMARA);
    }

    @Override
    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        if (requestCode == 1) {
            if (resultCode == Activity.RESULT_OK) {
                if (camaraComprobantesAvalAbierta) {

                    path = RealPathUtil.getRealPath(getActivity(), image_uri);
                    Bitmap bitmap = BitmapFactory.decodeFile(path);
                    pathsComprobantesAval.add(path);

                    banderaComprobantesAvales = pathsComprobantesAval.size() - 1;

                    Bitmap fullBitmap = BitmapFactory.decodeFile(path);
                    Bitmap reduceBitmap = Utils.reduceBitmapSize(fullBitmap, 950000);
                    File file = Utils.getBitmapFile(reduceBitmap, path);

                    RequestBody requestFile = RequestBody.create(MediaType.parse("multipart/form-data"), file);
                    MultipartBody.Part body = MultipartBody.Part.createFormData("archivo_aval_" + banderaComprobantesAvales, banderaComprobantesAvales + "CA.jpeg", requestFile);

                    archivosGeneral.add(body);

                    btnImagenesComprobantesAval.setText("Comprobantes (" + pathsComprobantesAval.size() + ")");
                }
                if (camaraGarantiasAvalAbierta) {

                    path = RealPathUtil.getRealPath(getActivity(), image_uri);
                    Bitmap bitmap = BitmapFactory.decodeFile(path);
                    pathsGarantiasAval.add(path);

                    banderaGarantiasAvales = pathsGarantiasAval.size() - 1;

                    Bitmap fullBitmap = BitmapFactory.decodeFile(path);
                    Bitmap reduceBitmap = Utils.reduceBitmapSize(fullBitmap, 950000);
                    File file = Utils.getBitmapFile(reduceBitmap, path);

                    RequestBody requestFile = RequestBody.create(MediaType.parse("multipart/form-data"), file);
                    MultipartBody.Part body = MultipartBody.Part.createFormData("garantia_aval_" + banderaGarantiasAvales, banderaGarantiasAvales + "GA.jpeg", requestFile);

                    archivosGeneral.add(body);

                    //btnImagenesGarantiasAval.setText("Garantías (" + pathsGarantiasAval.size() + ")");
                }
            }
        }
    }

    public void subirFotos() {

        ProgressDialog dialog = new ProgressDialog(getActivity(), R.style.AppMaterialAlertDialogStyle);
        dialog.setMessage("Guardando, por favor espere...");
        dialog.setCanceledOnTouchOutside(false);
        dialog.show();

        Retrofit retrofit = new Retrofit.Builder()
                .baseUrl(API.url)
                .addConverterFactory(GsonConverterFactory.create())
                .build();

        RetrofitInterface retrofitInterface = retrofit.create(RetrofitInterface.class);


        RequestBody func = RequestBody.create(MediaType.parse("multipart/form-data"), "subirFotos");
        RequestBody cliente_id = RequestBody.create(MediaType.parse("multipart/form-data"), aval.getId());

        RequestBody cantidad_archivos_garantias_aval = RequestBody.create(MediaType.parse("multipart/form-data"), pathsGarantiasAval.size() + "");
        RequestBody cantidad_archivos_aval = RequestBody.create(MediaType.parse("multipart/form-data"), pathsComprobantesAval.size() + "");


        Log.d("ARCHIVOS", archivosGeneral.toString());

        Call<ResponseMe> call = retrofitInterface.subirFotosA(archivosGeneral, func,
                cliente_id,
                cantidad_archivos_garantias_aval, cantidad_archivos_aval);
        call.enqueue(new Callback<ResponseMe>() {
            public void onResponse(Call<ResponseMe> call, retrofit2.Response<ResponseMe> response) {

                dialog.cancel();
                if (response.isSuccessful()) {

                    Log.d("response", response.body().getMessage());
                    Toast.makeText(getActivity(), "Se han subido las imagenes del cliente y su aval", Toast.LENGTH_LONG).show();
                    dialog.cancel();

                    Navigation.findNavController(getActivity(), R.id.nav_host_fragment_content_dashboard)
                            .navigate(R.id.nav_clientes);
                } else {
                    try {
                        JSONObject jObjError = new JSONObject(response.errorBody().string());

                        new MaterialAlertDialogBuilder(getActivity())
                                .setTitle("Aviso")
                                .setMessage(jObjError.getString("message"))
                                .setPositiveButton("Ok", new DialogInterface.OnClickListener() {
                                    @Override
                                    public void onClick(DialogInterface dialogInterface, int i) {
                                    }
                                })
                                .show();
                    } catch (Exception e) {
                        Toast.makeText(getContext(), e.getMessage(), Toast.LENGTH_LONG).show();
                    }
                }
            }

            @Override
            public void onFailure(Call<ResponseMe> call, Throwable t) {
                dialog.cancel();
                Log.d("TAG", "onFailure: " + t.getLocalizedMessage());
            }
        });
    }

}